//Note: Details of scilab software version and OS version used:
//OS: Windows 7
//Scilab version: 5.4.1
//IPD Atom version:8.3.1-2
//SIVP Atom version:0.5.3.1-2
//1.Quantization and sampling

//Quantize a signal to n bits.  This code assumes the signal is between -1
//and +1.
clc;
clear all;
close;
n=8;                       //Number of bits;
m= 120;                     //Number of samples;
t = 2*%pi*[0:(m-1)]/m;
x=sin(t);   //signal between -1 and 1.
                                //Trying "sin()" instead of "sawtooth"
                                //results in more interesting error(to the
                                //extent that error is interesting).
x(find(x>=1))=(1-%eps);     //Make  signal from -1 to just less than 1.
xq=floor((x+1)*2^(n-1));   //Signal is one of 2^n int values (0 to 2^n-1)
xq=xq/(2^(n-1));           //Signal is from 0 to 2 (quantized)
xq=xq-(2^(n)-1)/2^(n);     //Shift signal down (rounding)
 
xe=x-xq;                   //Error
subplot(3,1,1)
plot2d3('gnn',1:length(x),x);
title(sprintf('Signal, Quantized signal and Error for %g bits, %g quantization levels',n,2^n));
disp(x,'exact value')
subplot(3,1,2)
plot2d3('gnn',1:length(xq),xq,2);
title('Quantized Value')
disp(xq,'Quantized value')
subplot(3,1,3)
plot2d3('gnn',1:length(xe),xe,5);
title('Quantization Error or Quantization Noise')
disp(xe,'Quantization error or noise')



